package gov.va.med.mhv.sm.admin.model;

import gov.va.med.mhv.sm.admin.model.AbstractBaseEntity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "PATIENT_BLOCKED_HISTORY")
public class PatientBlockedHistory extends AbstractBaseEntity {

	private static final long serialVersionUID = 8192478075221166240L;

	@Id
	@Column(name = "PATIENT_BLOCKED_HISTORY_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "COMMENTS")
	private String comments;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "PATIENT_ID")
	private Long patientId;
	
	@Column(name = "PATIENT_STATUS")
	private Long patientStatus;
	
	@Column(name = "STATION_NUMBER")
	private Long stationNumber;

	@Column(name = "TRIAGE_GROUP_IDS")
	private String triageGroupIds;
	
	@Column(name = "USER_ID")
	private Long userId;

	public PatientBlockedHistory(){
		this.active=true;
		this.createdDate=new Date();
		this.modifiedDate=new Date();
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getPatientStatus() {
		return patientStatus;
	}

	public void setPatientStatus(Long patientStatus) {
		this.patientStatus = patientStatus;
	}

	public Long getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(Long stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getTriageGroupIds() {
		return triageGroupIds;
	}

	public void setTriageGroupIds(String triageGroupIds) {
		this.triageGroupIds = triageGroupIds;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}
	
}
